<?php

    use App\Http\Controllers\EntidadeController;
use App\Http\Controllers\MunicipioController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProvinceController;
use App\Http\Controllers\UserController;
use App\Models\Municipio;
use Illuminate\Support\Facades\Route;


    Route::get('/', function () {
        return view('welcome');
    });

    Route::get('/dashboard', function () {
        return view('dashboard');
    })->middleware(['auth', 'verified'])->name('dashboard');

    Route::middleware('auth')
    ->group(function () {
        Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    });

    


  
   require __DIR__.'/auth.php';

    
// Entidades
Route::get('/entidade', [EntidadeController::class, 'index'])->middleware(['auth', 'verified'])->name('entidade.index');
Route::get('/entidade/{valor}/show', [EntidadeController::class, 'show'])->middleware(['auth', 'verified'])->name('entidade.show'); 
Route::get('/entidade/{valor}/edit', [EntidadeController::class, 'edit'])->middleware(['auth', 'verified'])->name('entidade.edit');
Route::put('/entidade/{valor}/edit', [EntidadeController::class, 'update'])->middleware(['auth', 'verified'])->name('entidade.edit');
Route::delete('/entidade/destroy', [EntidadeController::class, 'destroy'])->middleware(['auth', 'verified'])->name('entidade.destroy');
// Entidades

// Users
Route::get('/utilizador', [UserController::class, 'index'])->middleware(['auth', 'verified'])->name('utilizador.index');
Route::get('/utilizador/{valor}/show', [UserController::class, 'show'])->middleware(['auth', 'verified'])->name('utilizador.show'); 
Route::get('/utilizador/create', [UserController::class, 'create'])->middleware(['auth', 'verified'])->name('utilizador.create');
Route::post('/utilizador/create', [UserController::class, 'store'])->middleware(['auth', 'verified'])->name('utilizador.create');
Route::delete('/utilizador/destroy', [UserController::class, 'destroy'])->middleware(['auth', 'verified'])->name('utilizador.destroy');
Route::post('/utilizador/activate', [UserController::class, 'activate'])->middleware(['auth', 'verified'])->name('utilizador.activate');
Route::post('/utilizador/deactivate', [UserController::class, 'deactivate'])->middleware(['auth', 'verified'])->name('utilizador.deactivate');
// Users

// Provincias
Route::get('/provincia', [ProvinceController::class, 'index'])->middleware(['auth', 'verified'])->name('provincia.index');
Route::get('/provincia/create', [ProvinceController::class,'create'])->middleware(['auth', 'verified'])->name('provincia.create');
Route::post('/provincia/create', [ProvinceController::class, 'store'])->middleware(['auth', 'verified'])->name('provincia.create');
Route::get('/provincia/{valor}/edit', [ProvinceController::class, 'edit'])->middleware(['auth', 'verified'])->name('provincia.edit');
Route::put('/provincia/{valor}/edit', [ProvinceController::class, 'update'])->middleware(['auth', 'verified'])->name('provincia.edit');
Route::delete('/provincia/destroy', [ProvinceController::class, 'destroy'])->middleware(['auth', 'verified'])->name('provincia.destroy');
// Provincias

// municipios
Route::get('/municipio', [MunicipioController::class, 'index'])->middleware(['auth', 'verified'])->name('municipio.index');
Route::get('/municipio/create', [MunicipioController::class,'create'])->middleware(['auth', 'verified'])->name('municipio.create');
Route::post('/municipio/create', [MunicipioController::class, 'store'])->middleware(['auth', 'verified'])->name('municipio.create');
Route::get('/municipio/{valor}/edit', [MunicipioController::class, 'edit'])->middleware(['auth', 'verified'])->name('municipio.edit');
Route::put('/municipio/{valor}/edit', [MunicipioController::class, 'update'])->middleware(['auth', 'verified'])->name('municipio.edit');
Route::delete('/municipio/destroy', [MunicipioController::class, 'destroy'])->middleware(['auth', 'verified'])->name('municipio.destroy');
// municipios

// parceiros
Route::get('/parceiro', [MunicipioController::class, 'index'])->middleware(['auth', 'verified'])->name('municipio.index');
Route::get('/parceiro/create', [MunicipioController::class,'create'])->middleware(['auth', 'verified'])->name('municipio.create');
Route::post('/parceiro/create', [MunicipioController::class, 'store'])->middleware(['auth', 'verified'])->name('municipio.create');
Route::get('/parceiro/{valor}/edit', [MunicipioController::class, 'edit'])->middleware(['auth', 'verified'])->name('municipio.edit');
Route::put('/parceiro/{valor}/edit', [MunicipioController::class, 'update'])->middleware(['auth', 'verified'])->name('municipio.edit');
Route::delete('/parceiro/destroy', [MunicipioController::class, 'destroy'])->middleware(['auth', 'verified'])->name('municipio.destroy');
// parceiros